import React, {Component} from 'react';
import PropTypes from 'prop-types';
import { Text, FormField } from 'react-form';
import ReactDateTime from 'react-datetime';

import moment from 'moment';
import 'moment/locale/it';

import './DateTime.css';

class DateTime extends Component {

    constructor(props) {
        super(props);
    }

    render() {

        const {
            fieldApi,
            onInput,
            label,
            field,
            ...rest
        } = this.props;

        const {
            getValue,
            getError,
            getWarning,
            getSuccess,
            setValue,
            setTouched,
        } = fieldApi;

        const error = getError();
        const warning = getWarning();
        const success = getSuccess();

        return (<div className="form-group request-form-group">
                <ReactDateTime
                    locale={"it"}
                    inputProps={{
                        ...rest,
                        className:"form-control",
                        placeholder: label,
                    }}
                    dateFormat={true}
                    timeFormat={true}
                    field={field}
                    id={field}
                    value={typeof getValue() === "string" ? moment(getValue()) : getValue()}
                    onChange={(value) => {
                        setValue(value);
                        if(onInput) {
                            onInput(value);
                        }
                    }} style={{width: "100%"}} />
            </div>);
    }

}

export default FormField(DateTime);

DateTime.defaultProps = {};

DateTime.propTypes = {
    label: PropTypes.string.isRequired
};